local orig_init = LightLoadingScreenGuiScript.init
function LightLoadingScreenGuiScript:init(scene_gui, res, progress, base_layer, is_win32)
	self._base_layer = base_layer
	self._is_win32 = is_win32
	self._scene_gui = scene_gui
	self._res = res
	self._ws = scene_gui:create_screen_workspace()
	self._safe_rect_pixels = self:get_safe_rect_pixels(res)
	self._saferect = self._scene_gui:create_screen_workspace()

	self:layout_saferect()

	local panel = self._ws:panel()
	self._panel = panel
	self._bg_gui = panel:rect({
		visible = true,
		color = Color.black,
		layer = base_layer
	})
	self._saferect_panel = self._saferect:panel()
	self._gui_tweak_data = {
		upper_saferect_border = 64,
		border_pad = 8
	}
	self._title_text = self._saferect_panel:text({
		y = 0,
		vertical = "bottom",
		h = 24,
		text_id = "debug_loading_level",
		font_size = 32,
		align = "left",
		font = "fonts/font_medium_mf",
		halign = "left",
		color = Color.white,
		layer = self._base_layer + 1
	})

	self._title_text:set_text(string.upper(self._title_text:text()))

	self._stonecold_small_logo = self._saferect_panel:bitmap({
		texture = "guis/textures/game_small_logo",
		name = "stonecold_small_logo",
		h = 56,
		texture_rect = {
			0,
			0,
			0,
			0
		},
		layer = self._base_layer - 1
	})

	self._stonecold_small_logo:set_size(0, 0)
	
	self._new_bg_gui = self._panel:bitmap({
            texture = "guis/switch",
			w = self._panel:w(),
			h = self._panel:h(),
            layer = self._base_layer
        })

	self._indicator = self._saferect_panel:bitmap({
		texture = "guis/textures/icon_loading",
		name = "indicator",
		layer = self._base_layer + 1
	})
	self._dot_count = 0
	self._max_dot_count = 4
	self._init_progress = 0
	self._fake_progress = 0
	self._max_bar_width = 0

	self:setup(res, progress)
end